MODULE_MAKEFILE_DIR := $(shell dirname $(abspath $(lastword $(MAKEFILE_LIST))))

# Run the module build.sh (wrapper for make) script with an empty environment, but PATH
HAS_KERNFS_NODE_PARENT := $(shell env -i CLANG="$(CLANG)" LLC="$(LLC)" PATH="$(PATH)" KERNELDIR="$(KERNELDIR)" sh $(MODULE_MAKEFILE_DIR)/build.sh ; echo $$?)

ifeq ($(HAS_KERNFS_NODE_PARENT),0)
$(info [configure-bpf] Setting HAS_KERNFS_NODE_PARENT flag)
KBUILD_CPPFLAGS += -DHAS_KERNFS_NODE_PARENT
else
HAS_KERNFS_NODE_PARENT_OUT1 := $(shell cat $(MODULE_MAKEFILE_DIR)/build.log | sed -n ':a;N;$$$!ba;s/\n/@@/g;P')
HAS_KERNFS_NODE_PARENT_OUT := $(subst @@,$(newline),$(HAS_KERNFS_NODE_PARENT_OUT1))
$(info [configure-bpf] Build output for HAS_KERNFS_NODE_PARENT:)
$(info [configure-bpf] $(HAS_KERNFS_NODE_PARENT_OUT))
endif

ifeq ('KERNFS_NODE_PARENT','0__SANITY')
    ifeq ($(HAS_KERNFS_NODE_PARENT),0)
        $(info [configure-bpf] Build system is sane)
    else
        $(info [configure-bpf] Build system is broken, please see above errors)
        $(error The build system is broken, please see above errors)
    endif
endif
