MODULE_MAKEFILE_DIR := $(shell dirname $(abspath $(lastword $(MAKEFILE_LIST))))

# Run the module build.sh (wrapper for make) script with an empty environment, but PATH
HAS_TASK_PIDS_FIELD := $(shell env -i CLANG="$(CLANG)" LLC="$(LLC)" PATH="$(PATH)" KERNELDIR="$(KERNELDIR)" sh $(MODULE_MAKEFILE_DIR)/build.sh ; echo $$?)

ifeq ($(HAS_TASK_PIDS_FIELD),0)
$(info [configure-bpf] Setting HAS_TASK_PIDS_FIELD flag)
KBUILD_CPPFLAGS += -DHAS_TASK_PIDS_FIELD
else
HAS_TASK_PIDS_FIELD_OUT1 := $(shell cat $(MODULE_MAKEFILE_DIR)/build.log | sed -n ':a;N;$$$!ba;s/\n/@@/g;P')
HAS_TASK_PIDS_FIELD_OUT := $(subst @@,$(newline),$(HAS_TASK_PIDS_FIELD_OUT1))
$(info [configure-bpf] Build output for HAS_TASK_PIDS_FIELD:)
$(info [configure-bpf] $(HAS_TASK_PIDS_FIELD_OUT))
endif

ifeq ('TASK_PIDS_FIELD','0__SANITY')
    ifeq ($(HAS_TASK_PIDS_FIELD),0)
        $(info [configure-bpf] Build system is sane)
    else
        $(info [configure-bpf] Build system is broken, please see above errors)
        $(error The build system is broken, please see above errors)
    endif
endif
