MODULE_MAKEFILE_DIR := $(shell dirname $(abspath $(lastword $(MAKEFILE_LIST))))

# Run the module build.sh (wrapper for make) script with an empty environment, but PATH
HAS_0__SANITY := $(shell env -i CLANG="$(CLANG)" LLC="$(LLC)" PATH="$(PATH)" KERNELDIR="$(KERNELDIR)" sh $(MODULE_MAKEFILE_DIR)/build.sh ; echo $$?)

ifeq ($(HAS_0__SANITY),0)
$(info [configure-bpf] Setting HAS_0__SANITY flag)
KBUILD_CPPFLAGS += -DHAS_0__SANITY
else
HAS_0__SANITY_OUT1 := $(shell cat $(MODULE_MAKEFILE_DIR)/build.log | sed -n ':a;N;$$$!ba;s/\n/@@/g;P')
HAS_0__SANITY_OUT := $(subst @@,$(newline),$(HAS_0__SANITY_OUT1))
$(info [configure-bpf] Build output for HAS_0__SANITY:)
$(info [configure-bpf] $(HAS_0__SANITY_OUT))
endif

ifeq ('0__SANITY','0__SANITY')
    ifeq ($(HAS_0__SANITY),0)
        $(info [configure-bpf] Build system is sane)
    else
        $(info [configure-bpf] Build system is broken, please see above errors)
        $(error The build system is broken, please see above errors)
    endif
endif
