MODULE_MAKEFILE_DIR := $(shell dirname $(abspath $(lastword $(MAKEFILE_LIST))))

# Run the module build.sh (wrapper for make) script with an empty environment, but PATH
HAS_RSS_STAT_ARRAY := $(shell env -i CLANG="$(CLANG)" LLC="$(LLC)" PATH="$(PATH)" KERNELDIR="$(KERNELDIR)" sh $(MODULE_MAKEFILE_DIR)/build.sh ; echo $$?)

ifeq ($(HAS_RSS_STAT_ARRAY),0)
$(info [configure-bpf] Setting HAS_RSS_STAT_ARRAY flag)
KBUILD_CPPFLAGS += -DHAS_RSS_STAT_ARRAY
else
HAS_RSS_STAT_ARRAY_OUT1 := $(shell cat $(MODULE_MAKEFILE_DIR)/build.log | sed -n ':a;N;$$$!ba;s/\n/@@/g;P')
HAS_RSS_STAT_ARRAY_OUT := $(subst @@,$(newline),$(HAS_RSS_STAT_ARRAY_OUT1))
$(info [configure-bpf] Build output for HAS_RSS_STAT_ARRAY:)
$(info [configure-bpf] $(HAS_RSS_STAT_ARRAY_OUT))
endif

ifeq ('RSS_STAT_ARRAY','0__SANITY')
    ifeq ($(HAS_RSS_STAT_ARRAY),0)
        $(info [configure-bpf] Build system is sane)
    else
        $(info [configure-bpf] Build system is broken, please see above errors)
        $(error The build system is broken, please see above errors)
    endif
endif
