MODULE_MAKEFILE_DIR := $(shell dirname $(abspath $(lastword $(MAKEFILE_LIST))))

# Run the module build.sh (wrapper for make) script with an empty environment,
# but pass PATH, KERNELDIR and eventually (if set) CC and KBUILD_MODPOST_WARN.
# The latter ones are used by driverkit build templates.
HAS_ACCESS_OK_2 := $(shell env -i CC="$(CC)" KBUILD_MODPOST_WARN="$(KBUILD_MODPOST_WARN)" PATH="$(PATH)" KERNELDIR="$(KERNELDIR)" sh $(MODULE_MAKEFILE_DIR)/build.sh ; echo $$?)

ifeq ($(HAS_ACCESS_OK_2),0)
$(info [configure-kmod] Setting HAS_ACCESS_OK_2 flag)
ccflags-y += -DHAS_ACCESS_OK_2
else
HAS_ACCESS_OK_2_OUT1 := $(shell cat $(MODULE_MAKEFILE_DIR)/build.log | sed -n ':a;N;$$$!ba;s/\n/@@/g;P')
HAS_ACCESS_OK_2_OUT := $(subst @@,$(newline),$(HAS_ACCESS_OK_2_OUT1))
$(info [configure-kmod] Build output for HAS_ACCESS_OK_2:)
$(info [configure-kmod] $(HAS_ACCESS_OK_2_OUT))
endif

ifeq ('ACCESS_OK_2','0__SANITY')
    ifeq ($(HAS_ACCESS_OK_2),0)
        $(info [configure-kmod] Build system is sane)
    else
        $(info [configure-kmod] Build system is broken, please see above errors)
        $(error The build system is broken, please see above errors)
    endif
endif
