// SPDX-License-Identifier: GPL-2.0-only OR MIT
/*

Copyright (C) 2023 The Falco Authors.

This file is dual licensed under either the MIT or GPL 2. See MIT.txt
or GPL2.txt for full copies of the license.

*/
#include "ppm_events_public.h"

#ifdef __KERNEL__
#include <linux/compat.h>
#include "ppm.h"
#endif /* __KERNEL__ */

#if defined(__KERNEL__)
#define FILLER_REF(x) f_##x, PPM_FILLER_##x
#else
#define FILLER_REF(x) 0, PPM_FILLER_##x
#endif /* __KERNEL__ */

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
const struct ppm_event_entry g_ppm_events[PPM_EVENT_MAX] = {
        [PPME_GENERIC_X] = {FILLER_REF(sys_generic)},
        [PPME_SYSCALL_OPEN_E] = {FILLER_REF(sys_open_e)},
        [PPME_SYSCALL_OPEN_X] = {FILLER_REF(sys_open_x)},
        [PPME_SYSCALL_CLOSE_X] = {FILLER_REF(sys_close_x)},
        [PPME_SYSCALL_READ_X] = {FILLER_REF(sys_read_x)},
        [PPME_SYSCALL_WRITE_X] = {FILLER_REF(sys_write_x)},
        [PPME_PROCEXIT_1_E] = {FILLER_REF(sys_procexit_e)},
        [PPME_SOCKET_SOCKET_X] = {FILLER_REF(sys_socket_x)},
        [PPME_SOCKET_BIND_X] = {FILLER_REF(sys_socket_bind_x)},
        [PPME_SOCKET_CONNECT_E] = {FILLER_REF(sys_connect_e)},
        [PPME_SOCKET_CONNECT_X] = {FILLER_REF(sys_connect_x)},
        [PPME_SOCKET_LISTEN_X] = {FILLER_REF(sys_listen_x)},
        [PPME_SOCKET_SEND_X] = {FILLER_REF(sys_send_x)},
        [PPME_SOCKET_SENDTO_X] = {FILLER_REF(sys_sendto_x)},
        [PPME_SOCKET_RECV_X] = {FILLER_REF(sys_recv_x)},
        [PPME_SOCKET_RECVFROM_X] = {FILLER_REF(sys_recvfrom_x)},
        [PPME_SOCKET_SHUTDOWN_X] = {FILLER_REF(sys_shutdown_x)},
        [PPME_SOCKET_GETSOCKNAME_X] = {FILLER_REF(sys_empty)},
        [PPME_SOCKET_GETPEERNAME_X] = {FILLER_REF(sys_empty)},
        [PPME_SOCKET_SOCKETPAIR_X] = {FILLER_REF(sys_socketpair_x)},
        [PPME_SOCKET_SETSOCKOPT_X] = {FILLER_REF(sys_setsockopt_x)},
        [PPME_SOCKET_GETSOCKOPT_X] = {FILLER_REF(sys_getsockopt_x)},
        [PPME_SOCKET_SENDMSG_X] = {FILLER_REF(sys_sendmsg_x)},
        [PPME_SOCKET_SENDMMSG_X] = {FILLER_REF(sys_sendmmsg_x)},
        [PPME_SOCKET_RECVMSG_X] = {FILLER_REF(sys_recvmsg_x)},
        [PPME_SOCKET_RECVMMSG_X] = {FILLER_REF(sys_recvmmsg_x)},
        [PPME_SYSCALL_CREAT_E] = {FILLER_REF(sys_creat_e)},
        [PPME_SYSCALL_CREAT_X] = {FILLER_REF(sys_creat_x)},
        [PPME_SYSCALL_PIPE_X] = {FILLER_REF(sys_pipe_x)},
        [PPME_SYSCALL_EVENTFD_X] = {FILLER_REF(sys_eventfd_x)},
        [PPME_SYSCALL_FUTEX_X] = {FILLER_REF(sys_futex_x)},
        [PPME_SYSCALL_STAT_X] = {FILLER_REF(sys_autofill), 2, APT_REG, {{AF_ID_RETVAL}, {0}}},
        [PPME_SYSCALL_LSTAT_X] = {FILLER_REF(sys_autofill), 2, APT_REG, {{AF_ID_RETVAL}, {0}}},
        [PPME_SYSCALL_FSTAT_X] = {FILLER_REF(sys_fstat_x)},
        [PPME_SYSCALL_STAT64_X] = {FILLER_REF(sys_autofill), 2, APT_REG, {{AF_ID_RETVAL}, {0}}},
        [PPME_SYSCALL_LSTAT64_X] = {FILLER_REF(sys_autofill), 2, APT_REG, {{AF_ID_RETVAL}, {0}}},
        [PPME_SYSCALL_FSTAT64_X] = {FILLER_REF(sys_single_x)},
        [PPME_SYSCALL_EPOLLWAIT_X] = {FILLER_REF(sys_epoll_wait_x)},
        [PPME_SYSCALL_POLL_X] = {FILLER_REF(sys_poll_x)},
        [PPME_SYSCALL_SELECT_X] = {FILLER_REF(sys_single_x)},
        [PPME_SYSCALL_LSEEK_X] = {FILLER_REF(sys_lseek_x)},
        [PPME_SYSCALL_LLSEEK_X] = {FILLER_REF(sys_single_x)},
        [PPME_SYSCALL_GETCWD_X] = {FILLER_REF(sys_getcwd_x)},
        [PPME_SYSCALL_CHDIR_X] = {FILLER_REF(sys_autofill), 2, APT_REG, {{AF_ID_RETVAL}, {0}}},
        [PPME_SYSCALL_FCHDIR_X] = {FILLER_REF(sys_fchdir_x)},
        [PPME_SYSCALL_UNLINK_X] = {FILLER_REF(sys_single_x)},
        [PPME_SYSCALL_UNLINKAT_X] = {FILLER_REF(sys_single_x)},
        [PPME_SYSCALL_PREAD_X] = {FILLER_REF(sys_pread64_x)},
        [PPME_SYSCALL_PWRITE_X] = {FILLER_REF(sys_pwrite64_x)},
        [PPME_SYSCALL_READV_X] = {FILLER_REF(sys_readv_x)},
        [PPME_SYSCALL_WRITEV_X] = {FILLER_REF(sys_writev_x)},
        [PPME_SYSCALL_PREADV_X] = {FILLER_REF(sys_preadv_x)},
        [PPME_SYSCALL_PWRITEV_X] = {FILLER_REF(sys_pwritev_x)},
        [PPME_SYSCALL_DUP_1_X] = {FILLER_REF(sys_dup_x)},
        [PPME_SYSCALL_DUP2_X] = {FILLER_REF(sys_dup2_x)},
        [PPME_SYSCALL_DUP3_X] = {FILLER_REF(sys_dup3_x)},
        [PPME_SYSCALL_SIGNALFD_X] = {FILLER_REF(sys_signalfd_x)},
        [PPME_SYSCALL_KILL_X] = {FILLER_REF(sys_kill_x)},
        [PPME_SYSCALL_TKILL_X] = {FILLER_REF(sys_tkill_x)},
        [PPME_SYSCALL_TGKILL_X] = {FILLER_REF(sys_tgkill_x)},
        [PPME_SYSCALL_NANOSLEEP_X] = {FILLER_REF(sys_nanosleep_x)},
        [PPME_SYSCALL_TIMERFD_CREATE_X] = {FILLER_REF(sys_timerfd_create_x)},
        [PPME_SYSCALL_INOTIFY_INIT_X] = {FILLER_REF(sys_inotify_init_x)},
        [PPME_SYSCALL_GETRLIMIT_X] = {FILLER_REF(sys_getrlimit_x)},
        [PPME_SYSCALL_SETRLIMIT_X] = {FILLER_REF(sys_setrlimit_x)},
        [PPME_SYSCALL_PRLIMIT_X] = {FILLER_REF(sys_prlimit_x)},
        [PPME_DROP_E] = {FILLER_REF(sched_drop)},
        [PPME_DROP_X] = {FILLER_REF(sched_drop)},
        [PPME_SYSCALL_FCNTL_X] = {FILLER_REF(sys_fcntl_x)},
#ifdef CAPTURE_CONTEXT_SWITCHES
        [PPME_SCHEDSWITCH_6_E] = {FILLER_REF(sched_switch_e)},
#endif
        [PPME_SYSCALL_BRK_4_X] = {FILLER_REF(sys_brk_x)},
        [PPME_SYSCALL_MMAP_X] = {FILLER_REF(sys_mmap_x)},
        [PPME_SYSCALL_MMAP2_X] = {FILLER_REF(sys_mmap2_x)},
        [PPME_SYSCALL_MUNMAP_X] = {FILLER_REF(sys_munmap_x)},
        [PPME_SYSCALL_SPLICE_X] = {FILLER_REF(sys_splice_x)},
        [PPME_SYSCALL_PTRACE_X] = {FILLER_REF(sys_ptrace_x)},
        [PPME_SYSCALL_IOCTL_3_X] = {FILLER_REF(sys_ioctl_x)},
        [PPME_SYSCALL_RENAME_X] = {FILLER_REF(sys_autofill),
                                   3,
                                   APT_REG,
                                   {{AF_ID_RETVAL}, {0}, {1}}},
        [PPME_SYSCALL_RENAMEAT_X] = {FILLER_REF(sys_renameat_x)},
        [PPME_SYSCALL_SYMLINK_X] = {FILLER_REF(sys_autofill),
                                    3,
                                    APT_REG,
                                    {{AF_ID_RETVAL}, {0}, {1}}},
        [PPME_SYSCALL_SYMLINKAT_X] = {FILLER_REF(sys_symlinkat_x)},
        [PPME_SYSCALL_SENDFILE_X] = {FILLER_REF(sys_sendfile_x)},
        [PPME_SYSCALL_QUOTACTL_X] = {FILLER_REF(sys_quotactl_x)},
        [PPME_SYSCALL_SETRESUID_X] = {FILLER_REF(sys_setresuid_x)},
        [PPME_SYSCALL_SETRESGID_X] = {FILLER_REF(sys_setresgid_x)},
        [PPME_SYSCALL_SETUID_X] = {FILLER_REF(sys_setuid_x)},
        [PPME_SYSCALL_SETGID_X] = {FILLER_REF(sys_setgid_x)},
        [PPME_SYSCALL_GETUID_X] = {FILLER_REF(sys_autofill), 1, APT_REG, {{AF_ID_RETVAL}}},
        [PPME_SYSCALL_GETEUID_X] = {FILLER_REF(sys_autofill), 1, APT_REG, {{AF_ID_RETVAL}}},
        [PPME_SYSCALL_GETGID_X] = {FILLER_REF(sys_autofill), 1, APT_REG, {{AF_ID_RETVAL}}},
        [PPME_SYSCALL_GETEGID_X] = {FILLER_REF(sys_autofill), 1, APT_REG, {{AF_ID_RETVAL}}},
        [PPME_SYSCALL_GETRESUID_X] = {FILLER_REF(sys_getresuid_and_gid_x)},
        [PPME_SYSCALL_GETRESGID_X] = {FILLER_REF(sys_getresuid_and_gid_x)},
        [PPME_SYSCALL_CLONE_20_X] = {FILLER_REF(proc_startupdate)},
        [PPME_SYSCALL_FORK_20_X] = {FILLER_REF(proc_startupdate)},
        [PPME_SYSCALL_VFORK_20_X] = {FILLER_REF(proc_startupdate)},
#ifdef CAPTURE_SIGNAL_DELIVERIES
        [PPME_SIGNALDELIVER_E] = {FILLER_REF(sys_signaldeliver_e)},
#endif
        [PPME_SYSCALL_GETDENTS_X] = {FILLER_REF(sys_getdents_x)},
        [PPME_SYSCALL_GETDENTS64_X] = {FILLER_REF(sys_getdents64_x)},
        [PPME_SYSCALL_SETNS_X] = {FILLER_REF(sys_setns_x)},
        [PPME_SYSCALL_FLOCK_X] = {FILLER_REF(sys_flock_x)},
        [PPME_CPU_HOTPLUG_E] = {FILLER_REF(cpu_hotplug_e)},
        [PPME_SOCKET_ACCEPT_5_X] = {FILLER_REF(sys_accept_x)},
        [PPME_SYSCALL_SEMOP_X] = {FILLER_REF(sys_semop_x)},
        [PPME_SYSCALL_SEMCTL_X] = {FILLER_REF(sys_semctl_x)},
        [PPME_SYSCALL_PPOLL_X] = {FILLER_REF(sys_ppoll_x)},
        [PPME_SYSCALL_MOUNT_X] = {FILLER_REF(sys_mount_x),
                                  4,
                                  APT_REG,
                                  {{AF_ID_RETVAL}, {0}, {1}, {2}}},
        [PPME_SYSCALL_SEMGET_X] = {FILLER_REF(sys_semget_x)},
        [PPME_SYSCALL_ACCESS_X] = {FILLER_REF(sys_access_x)},
        [PPME_SYSCALL_CHROOT_X] = {FILLER_REF(sys_autofill), 2, APT_REG, {{AF_ID_RETVAL}, {0}}},
        [PPME_SYSCALL_SETSID_X] = {FILLER_REF(sys_autofill), 1, APT_REG, {{AF_ID_RETVAL}}},
        [PPME_SYSCALL_SETPGID_X] = {FILLER_REF(sys_setpgid_x)},
        [PPME_SYSCALL_MKDIR_2_X] = {FILLER_REF(sys_mkdir_x)},
        [PPME_SYSCALL_RMDIR_2_X] = {FILLER_REF(sys_autofill), 2, APT_REG, {{AF_ID_RETVAL}, {0}}},
        [PPME_SYSCALL_UNSHARE_X] = {FILLER_REF(sys_unshare_x)},
        [PPME_SYSCALL_EXECVE_19_X] = {FILLER_REF(proc_startupdate)},
#ifdef CAPTURE_PAGE_FAULTS
        [PPME_PAGE_FAULT_E] = {FILLER_REF(sys_pagefault_e)},
#endif
        [PPME_SYSCALL_BPF_2_X] = {FILLER_REF(sys_bpf_x)},
        [PPME_SYSCALL_SECCOMP_X] = {FILLER_REF(sys_seccomp_x)},
        [PPME_SYSCALL_UNLINK_2_X] = {FILLER_REF(sys_autofill), 2, APT_REG, {{AF_ID_RETVAL}, {0}}},
        [PPME_SYSCALL_UNLINKAT_2_X] = {FILLER_REF(sys_unlinkat_x)},
        [PPME_SYSCALL_MKDIRAT_X] = {FILLER_REF(sys_mkdirat_x)},
        [PPME_SYSCALL_OPENAT_2_E] = {FILLER_REF(sys_openat_e)},
        [PPME_SYSCALL_OPENAT_2_X] = {FILLER_REF(sys_openat_x)},
        [PPME_SYSCALL_LINK_2_X] = {FILLER_REF(sys_autofill),
                                   3,
                                   APT_REG,
                                   {{AF_ID_RETVAL}, {0}, {1}}},
        [PPME_SYSCALL_LINKAT_2_X] = {FILLER_REF(sys_linkat_x)},
        [PPME_SYSCALL_FCHMODAT_X] = {FILLER_REF(sys_fchmodat_x)},
        [PPME_SYSCALL_CHMOD_X] = {FILLER_REF(sys_chmod_x)},
        [PPME_SYSCALL_FCHMOD_X] = {FILLER_REF(sys_fchmod_x)},
        [PPME_SYSCALL_RENAMEAT2_X] = {FILLER_REF(sys_renameat2_x)},
        [PPME_SYSCALL_USERFAULTFD_X] = {FILLER_REF(sys_autofill),
                                        2,
                                        APT_REG,
                                        {{AF_ID_RETVAL}, {0}}},
        [PPME_SYSCALL_OPENAT2_E] = {FILLER_REF(sys_openat2_e)},
        [PPME_SYSCALL_OPENAT2_X] = {FILLER_REF(sys_openat2_x)},
        [PPME_SYSCALL_MPROTECT_X] = {FILLER_REF(sys_mprotect_x)},
        [PPME_SYSCALL_EXECVEAT_X] = {FILLER_REF(proc_startupdate)},
        [PPME_SYSCALL_COPY_FILE_RANGE_X] = {FILLER_REF(sys_copy_file_range_x)},
        [PPME_SYSCALL_CLONE3_X] = {FILLER_REF(proc_startupdate)},
        [PPME_SYSCALL_OPEN_BY_HANDLE_AT_X] = {FILLER_REF(sys_open_by_handle_at_x)},
        [PPME_SYSCALL_IO_URING_SETUP_X] = {FILLER_REF(sys_io_uring_setup_x)},
        [PPME_SYSCALL_IO_URING_ENTER_X] = {FILLER_REF(sys_io_uring_enter_x)},
        [PPME_SYSCALL_IO_URING_REGISTER_X] = {FILLER_REF(sys_io_uring_register_x)},
        [PPME_SYSCALL_MLOCK_X] = {FILLER_REF(sys_mlock_x)},
        [PPME_SYSCALL_MUNLOCK_X] = {FILLER_REF(sys_munlock_x)},
        [PPME_SYSCALL_MLOCKALL_X] = {FILLER_REF(sys_mlockall_x)},
        [PPME_SYSCALL_MUNLOCKALL_X] = {FILLER_REF(sys_munlockall_x)},
        [PPME_SYSCALL_CAPSET_X] = {FILLER_REF(sys_capset_x)},
        [PPME_SYSCALL_MLOCK2_X] = {FILLER_REF(sys_mlock2_x)},
        [PPME_SYSCALL_FSCONFIG_X] = {FILLER_REF(sys_fsconfig_x)},
        [PPME_SYSCALL_EPOLL_CREATE_X] = {FILLER_REF(sys_epoll_create_x)},
        [PPME_SYSCALL_EPOLL_CREATE1_X] = {FILLER_REF(sys_epoll_create1_x)},
        [PPME_SYSCALL_CHOWN_X] = {FILLER_REF(sys_chown_x)},
        [PPME_SYSCALL_LCHOWN_X] = {FILLER_REF(sys_lchown_x)},
        [PPME_SYSCALL_FCHOWN_X] = {FILLER_REF(sys_fchown_x)},
        [PPME_SYSCALL_FCHOWNAT_X] = {FILLER_REF(sys_fchownat_x)},
        [PPME_SYSCALL_UMOUNT_1_X] = {FILLER_REF(sys_umount_x)},
        [PPME_SOCKET_ACCEPT4_6_X] = {FILLER_REF(sys_accept4_x)},
        [PPME_SYSCALL_UMOUNT2_X] = {FILLER_REF(sys_umount2_x)},
        [PPME_SYSCALL_PIPE2_X] = {FILLER_REF(sys_pipe2_x)},
        [PPME_SYSCALL_INOTIFY_INIT1_X] = {FILLER_REF(sys_inotify_init1_x)},
        [PPME_SYSCALL_EVENTFD2_X] = {FILLER_REF(sys_eventfd2_x)},
        [PPME_SYSCALL_SIGNALFD4_X] = {FILLER_REF(sys_signalfd4_x)},
        [PPME_SYSCALL_PRCTL_X] = {FILLER_REF(sys_prctl_x)},
        [PPME_SYSCALL_MEMFD_CREATE_X] = {FILLER_REF(sys_memfd_create_x)},
        [PPME_SYSCALL_PIDFD_GETFD_X] = {FILLER_REF(sys_pidfd_getfd_x)},
        [PPME_SYSCALL_PIDFD_OPEN_X] = {FILLER_REF(sys_pidfd_open_x)},
        [PPME_SYSCALL_INIT_MODULE_X] = {FILLER_REF(sys_init_module_x)},
        [PPME_SYSCALL_FINIT_MODULE_X] = {FILLER_REF(sys_finit_module_x)},
        [PPME_SYSCALL_MKNOD_X] = {FILLER_REF(sys_mknod_x)},
        [PPME_SYSCALL_MKNODAT_X] = {FILLER_REF(sys_mknodat_x)},
        [PPME_SYSCALL_NEWFSTATAT_X] = {FILLER_REF(sys_newfstatat_x)},
        [PPME_SYSCALL_PROCESS_VM_READV_X] = {FILLER_REF(sys_process_vm_readv_x)},
        [PPME_SYSCALL_PROCESS_VM_WRITEV_X] = {FILLER_REF(sys_process_vm_writev_x)},
        [PPME_SYSCALL_DELETE_MODULE_X] = {FILLER_REF(sys_delete_module_x)},
        [PPME_SYSCALL_SETREUID_X] = {FILLER_REF(sys_autofill),
                                     3,
                                     APT_REG,
                                     {{AF_ID_RETVAL}, {0}, {1}}},
        [PPME_SYSCALL_SETREGID_X] = {FILLER_REF(sys_autofill),
                                     3,
                                     APT_REG,
                                     {{AF_ID_RETVAL}, {0}, {1}}},
};
